/*
 * Decompiled with CFR 0.152.
 */
package jade.content.onto;

import jade.content.abs.AbsAggregate;
import jade.content.abs.AbsHelper;
import jade.content.abs.AbsObject;
import jade.content.onto.Introspector;
import jade.content.onto.Ontology;
import jade.content.onto.OntologyException;
import jade.content.onto.UngroundedException;
import jade.content.schema.AggregateSchema;
import jade.content.schema.ObjectSchema;
import jade.core.CaseInsensitiveString;
import jade.util.leap.List;
import java.lang.reflect.Method;

public class ReflectiveIntrospector
implements Introspector {
    public AbsObject externalise(Object obj, ObjectSchema schema, Class javaClass, Ontology referenceOnto) throws OntologyException {
        try {
            AbsObject abs = schema.newInstance();
            String[] names = schema.getNames();
            int i = 0;
            while (i < names.length) {
                String slotName = names[i];
                String methodName = "get" + this.translateName(slotName);
                Method getMethod = this.findMethodCaseInsensitive(methodName, javaClass);
                Object slotValue = this.invokeAccessorMethod(getMethod, obj);
                if (slotValue != null) {
                    ObjectSchema slotSchema = schema.getSchema(slotName);
                    if (slotSchema instanceof AggregateSchema) {
                        this.externaliseAndSetAggregateSlot(abs, schema, slotName, slotValue, slotSchema, referenceOnto);
                    } else {
                        AbsObject absSlotValue = referenceOnto.fromObject(slotValue);
                        AbsHelper.setAttribute(abs, slotName, absSlotValue);
                    }
                }
                ++i;
            }
            return abs;
        }
        catch (OntologyException oe) {
            throw oe;
        }
        catch (Throwable t) {
            throw new OntologyException("Schema and Java class do not match", t);
        }
    }

    protected void externaliseAndSetAggregateSlot(AbsObject abs, ObjectSchema schema, String slotName, Object slotValue, ObjectSchema slotSchema, Ontology referenceOnto) throws OntologyException {
        List l = (List)slotValue;
        if (!l.isEmpty() || schema.isMandatory(slotName)) {
            AbsAggregate absSlotValue = AbsHelper.externaliseList(l, referenceOnto, slotSchema.getTypeName());
            AbsHelper.setAttribute(abs, slotName, absSlotValue);
        }
    }

    protected Object invokeAccessorMethod(Method method, Object obj) throws OntologyException {
        try {
            return method.invoke(obj, (Object[])null);
        }
        catch (Exception e) {
            throw new OntologyException("Error invoking accessor method " + method.getName() + " on object " + obj, e);
        }
    }

    public Object internalise(AbsObject abs, ObjectSchema schema, Class javaClass, Ontology referenceOnto) throws UngroundedException, OntologyException {
        try {
            Object obj = javaClass.newInstance();
            String[] names = schema.getNames();
            int i = 0;
            while (i < names.length) {
                String slotName = names[i];
                AbsObject absSlotValue = abs.getAbsObject(slotName);
                if (absSlotValue != null) {
                    Object slotValue = null;
                    slotValue = absSlotValue.getAbsType() == 5 ? this.internaliseAggregateSlot((AbsAggregate)absSlotValue, referenceOnto) : referenceOnto.toObject(absSlotValue);
                    String methodName = "set" + this.translateName(slotName);
                    Method setMethod = this.findMethodCaseInsensitive(methodName, javaClass);
                    this.invokeSetterMethod(setMethod, obj, slotValue);
                }
                ++i;
            }
            return obj;
        }
        catch (OntologyException oe) {
            throw oe;
        }
        catch (InstantiationException ie) {
            throw new OntologyException("Class " + javaClass + " can't be instantiated", ie);
        }
        catch (IllegalAccessException iae) {
            throw new OntologyException("Class " + javaClass + " does not have an accessible constructor", iae);
        }
        catch (Throwable t) {
            throw new OntologyException("Schema and Java class do not match", t);
        }
    }

    private Object internaliseAggregateSlot(AbsAggregate absAggregate, Ontology referenceOnto) throws OntologyException {
        return AbsHelper.internaliseList(absAggregate, referenceOnto);
    }

    protected void invokeSetterMethod(Method method, Object obj, Object value) throws OntologyException {
        try {
            Object[] params = new Object[]{value};
            try {
                method.invoke(obj, params);
            }
            catch (IllegalArgumentException iae) {
                if (value instanceof Long) {
                    Integer i = new Integer((int)((Long)value).longValue());
                    params[0] = i;
                } else if (value instanceof Double) {
                    Float f = new Float((float)((Double)value).doubleValue());
                    params[0] = f;
                }
                method.invoke(obj, params);
            }
        }
        catch (Exception e) {
            throw new OntologyException("Error invoking setter method " + method.getName() + " on object " + obj + " with parameter " + value, e);
        }
    }

    public void checkClass(ObjectSchema schema, Class javaClass, Ontology onto) throws OntologyException {
    }

    protected Method findMethodCaseInsensitive(String name, Class c) throws OntologyException {
        Method[] methods = c.getMethods();
        int i = 0;
        while (i < methods.length) {
            String ithName = methods[i].getName();
            if (CaseInsensitiveString.equalsIgnoreCase(ithName, name)) {
                return methods[i];
            }
            ++i;
        }
        throw new OntologyException("Method " + name + " not found in class " + c.getName());
    }

    protected String translateName(String name) {
        StringBuffer buf = new StringBuffer();
        boolean capitalize = true;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            switch (c) {
                case ':': {
                    break;
                }
                case '-': {
                    capitalize = true;
                    break;
                }
                default: {
                    if (capitalize) {
                        buf.append(Character.toUpperCase(c));
                        capitalize = false;
                        break;
                    }
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }
}

